<?php
/*-
 * KKiTunewReview - version 1.0
 * 
 * Auther Kouhei Kido (http://blog.9wick.com)
 * 
 ********************************************************************
 * Copyright (c) 2011 Kouhei Kido, All rights reserved.
 ********************************************************************
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR(S) ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR(S) BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */


require_once 'KKiTunesReview.php';
mb_internal_encoding("UTF-8");

try {

    set_time_limit(0);
    $config = parse_ini_file('config.ini', true);
    $apps = array();
    foreach($config['apps']['id'] as $key => $id){
        $app = array();
        $app['name'] = isset($config['apps']['name'][$key]) ? $config['apps']['name'][$key] : 'app';
        $app['to'] = isset($config['apps']['to'][$key]) ? $config['apps']['to'][$key] : $config['mail']['to'];
        $app['from'] = isset($config['apps']['from'][$key]) ? $config['apps']['from'][$key] : $config['mail']['from'];
        $app['id'] = $id;
        
        $apps[] = $app;
        
    }
    $countries = AppITunesBrowser::getCountries();
    $browser = new AppITunesBrowser();
    foreach($apps as $app){    
        foreach ($countries as $country) {
            $i = 0;
            while ($i < $config['review']['maxPage']) {
                $browser->getAppDataInCounty($app['id'], $country['code'], $i++); 
                
                $j = 0;
                $stringIndex = 0;
                while($j < $config['review']['maxReviewPerPage']){
                    $j++;
                    $review = new AppITunesReviewBean($app['name'], $app['id'], $country['name'], $country['code'], $browser->getContents(), $stringIndex);
                    if($review->state){
                        if(!$review->isSaved()){
                            $review->save();
                            $review->mail($app['to'],$app['from']);
                        }
                    }else{
                        break;
                    }
                }
                if ($browser->isLastReview()) {
                    break;
                }
            }
        }
    }
} catch (Exception $e) {
   echo "Error";
}

?>

</body></html>