<?php
/*-
 * KKiTunewReview - version 1.0
 * 
 * Auther Kouhei Kido (http://blog.9wick.com)
 * 
 ********************************************************************
 * Copyright (c) 2011 Kouhei Kido, All rights reserved.
 ********************************************************************
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR(S) ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR(S) BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

require_once 'htmlsql.class.php';

class Database{
    private $_host;
    private $_user;
    private $_pass;
    private $_connect;

    public function __construct($host, $dbName, $user, $password = NULL) {

        $this->_host = $host;

        $this->_user = $user;
        $this->_pass = $password;
        

        $this->_connect = mysql_connect($this->_host,  $this->_user, $this->_pass);
        if(!$this->_connect){
            throw new Exception("db open error");
            exit;
        }

        mysql_set_charset("utf8"); 
   
        mysql_select_db($dbName);


    }


    public function __destruct(){

        mysql_close($this->_connect);

    }

    public function query($sql){
        $dbResult = mysql_query($sql);
        if ($dbResult == false) {
            throw new Exception(    mysql_error() ." with sql :" . $sql );
        }
        return $dbResult;
    }

    public function lastInsertId(){
        return mysql_insert_id();
    }

    public function fetchAll($sql){
        $result = array();

        $dbResult =  $this->query($sql);
        while ($row = mysql_fetch_assoc($dbResult)) {
            $result[] = $row;
        }

        mysql_free_result($dbResult);
        return $result;
    }

    public function fetchRow($sql){
        
        $dbResult = $this->query($sql);
        $result =  mysql_fetch_assoc($dbResult);
        mysql_free_result($dbResult);
        
        return $result;
    }

    public function fetchOne($sql){
        $dbResult =  $this->query($sql);
        $resultArray =  mysql_fetch_row($dbResult);
        mysql_free_result($dbResult);

        return $resultArray[0];


    }


}

class App{
    static $_db;

    static function getDB(){
        if(!self::$_db){
            $config = parse_ini_file('config.ini', true);
            $host = $config['db']['host'];
            $dbName = $config['db']['dbName'];
            $user = $config['db']['user'];
            $password = $config['db']['password'];
            self::$_db = new Database($host, $dbName, $user, $password);
        }

        return self::$_db;
    }

}

class AppCurl {
  const POST = 'post';
  const GET = 'get';
  
  
  private $ch;
  private $url = '';
  private $params = array();
  private $method = 'get';
  private $header = array();


  public function __construct($url) {
    $this->ch = curl_init();
    curl_setopt($this->ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($this->ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
   
    $this->url = $url;
  }
  
  public function __destruct() {
    curl_close($this->ch);
  
  }
  
  public function setUserAgent($userAgent){
    curl_setopt($this->ch, CURLOPT_USERAGENT, $userAgent);
      
  }
  
  public function getContents(){
    if($this->method == self::POST && count($this->params) != 0){
      curl_setopt($this->ch, CURLOPT_URL, $this->url);
      curl_setopt($this->ch, CURLOPT_POST, 1);
      curl_setopt($this->ch, CURLOPT_POSTFIELDS, $this->paramsString());
      
    }else if($this->method == self::GET && count($this->params) != 0){
      $url = $this->url . '&' . $this->paramsString();
      curl_setopt($this->ch, CURLOPT_URL, $url);
      
    }else{
      curl_setopt($this->ch, CURLOPT_URL, $this->url);
      
    }
    
    if(count($this->header) > 0){
        $header = array();
        foreach ($this->header as $key => $value){
            $header[] = $key . ": " .$value;
        }
        curl_setopt($this->ch, CURLOPT_HTTPHEADER, $header);
        
    }
    
    return curl_exec($this->ch);
    
  }
  
  public function post(){
    $this->setMethod(self::POST);
    return $this->getContents();
  }
  
  public function setMethod($method){
    $this->method = $method;
    return $this;
  }
  
  public function setSsl(){
    curl_setopt($this->ch, CURLOPT_SSL_VERIFYPEER, FALSE); // サーバ証明書検証をスキップ
    curl_setopt($this->ch, CURLOPT_SSL_VERIFYHOST, FALSE); // サーバ証明書検証をスキップ
    return $this;
  }
  
  private function paramsString(){
    $params = array();
    foreach ($this->params as $key => $value){
      $params[] = $key . '=' . $value;
      
    }
    
    return implode('&', $params);
  }
  
  public function setParam($name, $value){
    $this->params[$name] = $value;
    return $this;
  }
  
  public function getHeder(){
    curl_setopt ($this->ch, CURLOPT_HEADER, 1);
    return $this->getContents();
    
  }
  
  public function setHttpHeader($key, $value){
      $this->header[$key] = $value;
  }
  
  public function setReferer($url){
    curl_setopt($this->ch, CURLOPT_REFERER, $url);
    return $this;
  }
  
  public function setCookie($fileName){
    if( !file_exists($fileName) ){
        touch( $fileName );
    }
    curl_setopt($this->ch, CURLOPT_COOKIEFILE, $fileName);
    curl_setopt($this->ch, CURLOPT_COOKIEJAR, $fileName); 
  }
  
  public function setRedirect($maxRedirectCount = 10){
    curl_setopt($this->ch, CURLOPT_FOLLOWLOCATION, true); 
    curl_setopt($this->ch, CURLOPT_MAXREDIRS, $maxRedirectCount); 
    
  }
  
  
  public function download($fileName){
    $fp = fopen($fileName, "w");
    curl_setopt($this->ch, CURLOPT_FILE, $fp);
    $this->getContents();
    fclose($fp);
  }
  
  public function setProxy($url, $port = 8080, $user = 'anonymous', $pass = ''){

    curl_setopt($this->ch, CURLOPT_HTTPPROXYTUNNEL, 1);
    curl_setopt($this->ch, CURLOPT_PROXY, $url . ":" . $port);
    curl_setopt($this->ch, CURLOPT_PROXYPORT, $port);
    curl_setopt($this->ch, CURLOPT_PROXYUSERPWD, $user . ":" . $pass);

  }
}

class AppBrowser {
    private $cookieFileName = "";
    private $url = "";
    private $urlData = array();
    private $contents = "";
    private $targetForm;
    private $formParams;
    private $httpHeaders =array();
    const USER_AGENT = 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_6_7) AppleWebKit/534.24 (KHTML, like Gecko) Chrome/11.0.696.65 Safari/534.24';
  
    
    
    public function getParams(){
        $params = array();
        foreach ($this as $key => $value){
            $params[$key] = $value;
        }
        return $params;
    }
    
    public function setParams($params){
        
        foreach ($params as $key => $value){
            $this->$key = $value;
        }
        
    }
    
    public function getUrl(){
        return $this->url;
    }
    
    public function getContents(){
        return $this->contents;
    }
    
    public function __construct() {
        $this->cookieFileName =  time() . rand(1, 9999);
    }
    
    public function __destruct() {
        //unlink($this->cookieFileName);
    }
    
    
    protected function getCurl($url) {
        $curl = new AppCurl($url);
        $curl->setCookie($this->cookieFileName);
        $curl->setReferer($this->url);
        $curl->setUserAgent(self::USER_AGENT);
        return $curl;
    }
    
    public function download($url, $method = 'get', $params = array()){
        
        if(!$this->isAbsolutePath($url)){
            if(!isset($this->urlData['scheme'])){
                exit;
            }
            $url = $this->urlData['scheme'] . "://" . $this->urlData['host'] . $url;
        }
        $curl = $this->getCurl($url);
        if($this->isHttps($url)){
            $curl->setSsl();
        }
        
        
        $curl->setRedirect();
                
        $this->url = $url;
        $this->urlData = parse_url($url);
        
        foreach ($params as $key => $value){
            $curl->setParam($key, $value);
        }
        
        foreach ($this->httpHeaders as $key => $value){
            $curl->setHttpHeader($key, $value);
        }
        
        if($method == 'post'){
            $this->contents = $curl->post();
        }else{
            $this->contents = $curl->getContents();
        }
        return $this->contents;
    }

    
    private function isHttp($url = null){
        if($url === null){
            $url = $this->url;
        }
        return $this->startsWith($url, 'http://');
    }
    
    private function isHttps($url = null){
        if($url === null){
            $url = $this->url;
        }
        return $this->startsWith($url, 'https://');
    }
    
    private function isAbsolutePath($url = null){
        return ($this->isHttp($url) || $this->isHttps($url));
    }
    
    private function startsWith($haystack, $needle){
        return strpos($haystack, $needle, 0) === 0;
    }
    
    public function getTags($tag = '*', $where = array(), $pregText = NULL, $contents = NULL){
        
        $wsql = new htmlsql();
        if(!$contents){
            $contents = $this->getContents();
        }
        $wsql->connect('string', $contents);
        $query = "SELECT * FROM " . $tag;
        
        $whereStrings = array();
        foreach ($where as $key => $value){
            $whereStrings[] = "\$" . $key . " == '" . $value . "'";
        }
        if($pregText){
            $whereStrings[] = "preg_match('". $pregText ."', \$text)";
        }
        
        if(count($whereStrings) > 0){
            $query .= " WHERE " . implode(' AND ', $whereStrings);
        }
        $wsql->query($query);
        $results =  $wsql->fetch_array();
        return $results;
    }
    
    public function getFirstTag($tag = '*', $where = array(), $pregText = NULL, $contents = NULL){
        $tags = $this->getTags($tag, $where, $pregText, $contents);
        return reset($tags);
    }
    
    public function setTargetForm($where = array(), $pregText = NULL){
        
        $this->targetForm = $this->getFirstTag('form', $where, $pregText);
        $formParams = array();
        
        
        $inputTags =  $this->getTags('input',array(), null, $this->targetForm['text']);
         
        foreach ($inputTags as $input){
            if($input['type'] != 'hidden'){continue;}
            $formParams[$input['name']] = isset($input['value']) ? $input['value'] : "";
        }
        $this->formParams = $formParams;
        return $this->targetForm;
    }
    
    public function setForm($formParams){
        $this->formParams = $formParams;
    }
    
    public function setFormParam($key, $value){
        $this->formParams[$key] = $value;
    }
    
    public function submit(){
        
        return $this->download($this->targetForm['action'], $this->targetForm['method'], $this->formParams);
    }
    
    
    public function clickLinkPregMach($pregText){
        $aTag = $this->getFirstTag('a', array(), $pregText);
        return $this->download($aTag['href']);
    }
    
    public function setHttpHeader($key,$value){
        $this->httpHeaders[$key] = $value;
    }
    
}

class AppITunesBrowser extends AppBrowser{
    const USER_AGENT = "iTunes/9.2 (Windows; Microsoft Windows 7 Home Premium Edition (Build 7600)) AppleWebKit/533.16";
    
    static $countries = array(
        array('name' => "アメリカ合衆国", "code" =>"143441"),
    	array('name' => "アルゼンチン", "code" =>"143505"),
    	array('name' => "オーストラリア", "code" =>"143460"),
    	array('name' => "ベルギー", "code" =>"143446"),
    	array('name' => "ブラジル", "code" =>"143503"),
    	array('name' => "カナダ", "code" =>"143455"),
    	array('name' => "チリ", "code" =>"143483"),
    	array('name' => "中国", "code" =>"143465"),
    	array('name' => "コロンビア", "code" =>"143501"),
    	array('name' => "コスタリカ", "code" =>"143495"),
    	array('name' => "クロアチア", "code" =>"143494"),
    	array('name' => "チェコ", "code" =>"143489"),
    	array('name' => "デンマーク", "code" =>"143458"),
    	array('name' => "ドイツ", "code" =>"143443"),
    	array('name' => "エルサルバドル", "code" =>"143506"),
    	array('name' => "スペイン", "code" =>"143454"),
    	array('name' => "フィンランド", "code" =>"143447"),
    	array('name' => "フランス", "code" =>"143442"),
    	array('name' => "ギリシャ", "code" =>"143448"),
    	array('name' => "グァテマラ", "code" =>"143504"),
    	array('name' => "香港", "code" =>"143463"),
    	array('name' => "ハンガリー", "code" =>"143482"),
    	array('name' => "インド", "code" =>"143467"),
    	array('name' => "インドネシア", "code" =>"143476"),
    	array('name' => "アイルランド", "code" =>"143449"),
    	array('name' => "イスラエル", "code" =>"143491"),
    	array('name' => "イタリア", "code" =>"143450"),
    	array('name' => "韓国", "code" =>"143466"),
    	array('name' => "クウェート", "code" =>"143493"),
    	array('name' => "レバノン", "code" =>"143497"),
    	array('name' => "ルクセンブルク", "code" =>"143451"),
    	array('name' => "マレーシア", "code" =>"143473"),
    	array('name' => "メキシコ", "code" =>"143468"),
    	array('name' => "オランダ", "code" =>"143452"),
    	array('name' => "ニュージーランド", "code" =>"143461"),
    	array('name' => "ノルウェイ", "code" =>"143457"),
    	array('name' => "オーストリア", "code" =>"143445"),
    	array('name' => "パキスタン", "code" =>"143477"),
    	array('name' => "パナマ", "code" =>"143485"),
    	array('name' => "ペルー", "code" =>"143507"),
    	array('name' => "フィリピン", "code" =>"143474"),
    	array('name' => "ポーランド", "code" =>"143478"),
    	array('name' => "ポルトガル", "code" =>"143453"),
    	array('name' => "カタール", "code" =>"143498"),
    	array('name' => "ルーマニア", "code" =>"143487"),
    	array('name' => "ロシア", "code" =>"143469"),
    	array('name' => "サウジアラビア", "code" =>"143479"),
    	array('name' => "スイス", "code" =>"143459"),
    	array('name' => "シンガポール", "code" =>"143464"),
    	array('name' => "スロバキア", "code" =>"143496"),
    	array('name' => "スロベニア", "code" =>"143499"),
    	array('name' => "南アフリカ", "code" =>"143472"),
    	array('name' => "スリランカ", "code" =>"143486"),
    	array('name' => "スウェーデン", "code" =>"143456"),
    	array('name' => "台湾", "code" =>"143470"),
    	array('name' => "タイ", "code" =>"143475"),
    	array('name' => "トルコ", "code" =>"143480"),
    	array('name' => "アラブ首長国連邦", "code" =>"143481"),
    	array('name' => "イギリス", "code" =>"143444"),
    	array('name' => "ベネズエラ", "code" =>"143502"),
    	array('name' => "ベトナム", "code" =>"143471"),
    	array('name' => "日本", "code" =>"143462"),	
    );
    
    public static function getCountries(){
        return self::$countries;
    }

    
    
    protected function getCurl($url) {
        $curl = new AppCurl($url);
        $curl->setUserAgent(self::USER_AGENT);
        return $curl;
    }

    public function download($url, $method = 'get', $params = array()) {
        
        $url = strtr($url, array("&amp;" => "&"));
        return parent::download($url, $method, $params);
    }


    public function getAppDataInCounty($appId,$countryCode,$page = 0){
        
        $url = "http://ax.itunes.apple.com/WebObjects/MZStore.woa/wa/viewContentsUserReviews?id=";
        $url .= $appId;
        $url .= "&pageNumber=" . $page . "&sortOrdering=4&type=Purple+Software&onlyLatestVersion=false";
    	$this->setHttpHeader("X-Apple-Store-Front","" . $countryCode . "-1");
        
        return $this->download($url);
        
    }
    
    public function isLastReview(){
        $params = array(
            'topinset'  =>"0",
            "leftinset" =>"0",
            "styleset"  =>"basic12",
            "textjust"  =>"left"
        );
        $tag = $this->getFirstTag('TextView', $params,'/Page /');
        $pagerTag = $this->getFirstTag('b',array(),NULL,$tag['text']);
        $pagerString = trim($pagerTag['text']); //Page 2 of 3
        
        $elements = explode(' ', $pagerString);
        $max = trim(array_pop($elements));
        $of = trim(array_pop($elements));
        $now = trim(array_pop($elements));
        return ($max == $now);
    }
    
}

class AppITunesReviewBean {
    public $appName;
    public $countryName;
    public $appId;
    public $countryCode;
    public $title;
    public $star;
    public $starString;
    public $userId;
    public $userName;
    public $version;
    public $datetime;
    public $date;
    public $body;
    
    public $state;
    
    public function __construct($appName, $appId, $countryName, $countryCode, $string, &$stringIndex) {
        $this->appName = $appName;
        $this->countryName = $countryName;
        
        $this->state = $this->analyzeData($appId, $countryCode, $string, $stringIndex);
    }
    
    function getTextBetween($content, &$id, $start, $end){
        $string = (string)$content;
        $ini = strpos($string,$start, $id);
        if ($ini === false) {
            $id = -1;
            return "";
        }
        $ini += strlen($start);
        $last =strpos($string,$end,$ini); 
        if($last === false){
            $id = -1;
            return "";
        }
        
        $len = $last - $ini;
        $id = $ini + $len;
        
        return trim( substr($string,$ini,$len));

    }

    private function analyzeData($appId, $countryCode, $data, &$id){
        $this->appId = $appId;
        $this->countryCode = $countryCode;
        
        //title
        $start = "styleSet=\"basic13\" textJust=\"left\" maxLines=\"1\"><SetFontStyle normalStyle=\"textColor\"><b>";
        $end = "</b>";
        $this->title = $this->getTextBetween($data, $id, $start, $end);
        if($id < 0){return false;}
        
        //star
        $start = "<HBoxView topInset=\"1\" alt=\"";
        $end = " star";
        $this->star = $this->getTextBetween($data, $id, $start, $end);
        if($id < 0){return false;}
        $this->starString = "";
        for($i = 0; $i<$this->star; $i++){
           $this->starString .= "★";
        }
        
        
        //userId
        $start = "userReviewId=";
        $end = "\">";
        $this->userId = $this->getTextBetween($data, $id, $start, $end);
        if($id < 0){return false;}
       $fromId = $id;
       
        //Anonymous
        $start = "by";
        $end = "<";
        $this->userName = $this->getTextBetween($data, $id, $start, $end);
        if($id < 0){return false;}
       
         //userName
        if($this->userName == ''){
            $start = "\">";
            $end =  "</GotoURL>";
            $this->userName = $this->getTextBetween($data, $id, $start, $end);
            if($id < 0){return false;}
            
            $nameId = 0;
            $name = $this->getTextBetween($this->userName, $nameId, '<b>', '</b>');
            if($name){
                $this->userName = $name;
            }
            
            
        }
        
        
        
        //version
        $tmpId = $id;  // Anonymous
        $start = "Version ";
        $end =  "-";
        $this->version = $this->getTextBetween($data, $id, $start, $end);
        if($id < 0){ 
            $id = $tmpId;
        }
        $toId = $id;
        
       
        //date
        $tmpId = $id;  // Anonymous
        $start = " ";
        $end =  "</SetFontStyle></TextView>";
        $this->datetime = strtotime($this->getTextBetween($data, $id, $start, $end));
        $this->date = date('Y/m/d', $this->datetime);
        if($id < 0 || $this->datetime == -1 || $this->datetime === false){
            $id = $tmpId;
            $this->datetime = 0;
            $this->date = '';
        }
       
        
        //body
        $start = "styleSet=\"normal11\" textJust=\"left\"><SetFontStyle normalStyle=\"textColor\">";
        $end = "</SetFontStyle></TextView>";
        $this->body = $this->getTextBetween($data, $id, $start, $end);
        if($id < 0){return false;}
        
        return true;
       
    }
    
    
    public function echoTable(){
        $keys = array(
            'アプリ名' => 'appName',
            '国' => 'countryName',
            'ユーザーID' => 'userId',
            'ユーザー名' => 'userName',
            '日付' => 'date',
            'バージョン' => 'version',
            'タイトル' => 'title',
            '評価' => 'starString',
            '本文' => 'body',
        );
        
        echo "<table border='1'>";
        
        foreach($keys as $key => $value ){
            echo "<tr><th style='width: 100px'>" . $key . "</th><td>". nl2br($this->$value) . "</td></tr>";
        }
        echo "</table>";
        
    }
    
    public function echoText(){
        $keys = array(
            'アプリ名' => 'appName',
            '国' => 'countryName',
            'ユーザーID' => 'userId',
            'ユーザー名' => 'userName',
            '日付' => 'date',
            'バージョン' => 'version',
            'タイトル' => 'title',
            '評価' => 'starString',
            '本文' => 'body',
        );
        
        
        foreach($keys as $key => $value ){
            echo "<" . $key . ">\n". $this->$value . "\n\n";
        }
        
    }
    
    public function isSaved(){
        $keys = array(
            'appId',
            'countryCode',
            'userId',
            'datetime'
        );
        
        $sql = 'select 1 from review where ';
        
        $where = array();
        foreach ($keys as $key){
            $where[] =  $this->_strLower($key) . " = " . $this->$key;
        }
        
        $sql .= implode(' AND ', $where);
        
        return (App::getDB()->fetchOne($sql) == 1);
        
    }
    
    private function _strLower($string){
       return strtolower(preg_replace('/[A-Z]/', '_$0', $string));
    }


    public function save(){
        $allKeys = array(
            'appId',
            'appName',
            'countryCode',
            'countryName',
            'star',
            'userId',
            'userName',
            'version',
            'datetime',
            'title',
            'body'
        );
        
        $values = array();
        $keys = array();
        foreach ($allKeys as $key){
            $keys[] =  $this->_strLower($key);
            $values[] =  mysql_real_escape_string($this->$key);
        }
        
        $sql = 'insert into review ('. implode(',', $keys) .') VALUES (\'' . implode('\' , \'', $values) . '\')';
        
        return App::getDB()->query($sql);
        
    }
    
    public function mail($to, $from){

        ob_start();
        $this->echoText();
        mail($to, '[review]'.$this->appName,  ob_get_contents()  ,
                'MIME-Version: 1.0' . "\r\n"  .
                'Content-type: text/plain; charset=utf-8' . "\r\n" . 
                'From: ' . $from . "\r\n");
        ob_end_clean();
    }

}